#
#	MBsysTran - Release 8.1
#
#	Copyright 
#	Universite catholique de Louvain (UCLouvain) 
#	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
#	2, Place du Levant
#	1348 Louvain-la-Neuve 
#	Belgium 
#
#	http://www.robotran.be 
#
#	==> Generation Date: Wed Sep 15 15:32:03 2021
#
#	==> Project name: five_point_suspension_python
#
#	==> Number of joints: 16
#
#	==> Function: F2 - Recursive Inverse Dynamics of tree-like MBS
#
#	==> Git hash: e4323cc50f813318b5c64b3b53763c941a34ce32
#

from math import sin, cos

def invdyna(phi,s,tsim):
    Qq = phi  # compatibility with symbolic generation
    q = s.q
    qd = s.qd
    qdd = s.qdd
 
# Trigonometric functions

    S2 = sin(q[2])
    C2 = cos(q[2])
    S3 = sin(q[3])
    C3 = cos(q[3])
    S4 = sin(q[4])
    C4 = cos(q[4])
    S5 = sin(q[5])
    C5 = cos(q[5])
    S6 = sin(q[6])
    C6 = cos(q[6])
    S7 = sin(q[7])
    C7 = cos(q[7])
    S8 = sin(q[8])
    C8 = cos(q[8])
    S9 = sin(q[9])
    C9 = cos(q[9])
    S10 = sin(q[10])
    C10 = cos(q[10])
    S11 = sin(q[11])
    C11 = cos(q[11])
    S12 = sin(q[12])
    C12 = cos(q[12])
    S13 = sin(q[13])
    C13 = cos(q[13])
    S14 = sin(q[14])
    C14 = cos(q[14])
    S15 = sin(q[15])
    C15 = cos(q[15])
 
# Augmented Joint Position Vectors

 
# Forward Kinematics

    ALPHA31 = qdd[1]-s.g[3]
    ALPHA22 = ALPHA31*S2
    ALPHA32 = ALPHA31*C2
    OM13 = qd[2]*C3
    OM23 = -qd[2]*S3
    OMp13 = -qd[2]*qd[3]*S3+qdd[2]*C3
    BS23 = OM13*OM23
    BS53 = -qd[3]*qd[3]-OM13*OM13
    BS63 = qd[3]*OM23
    BETA23 = -qdd[3]+BS23
    BETA83 = BS63+OMp13
    ALPHA13 = ALPHA22*S3
    ALPHA23 = ALPHA22*C3
    ALPHA24 = ALPHA31*S4
    ALPHA34 = ALPHA31*C4
    OM15 = qd[4]*C5
    OM25 = -qd[4]*S5
    OMp15 = -qd[4]*qd[5]*S5+qdd[4]*C5
    BS25 = OM15*OM25
    BS55 = -qd[5]*qd[5]-OM15*OM15
    BS65 = qd[5]*OM25
    BETA25 = -qdd[5]+BS25
    BETA85 = BS65+OMp15
    ALPHA15 = ALPHA24*S5
    ALPHA25 = ALPHA24*C5
    ALPHA26 = ALPHA31*S6
    ALPHA36 = ALPHA31*C6
    OM17 = qd[6]*C7
    OM27 = -qd[6]*S7
    OMp17 = -qd[6]*qd[7]*S7+qdd[6]*C7
    BS27 = OM17*OM27
    BS57 = -qd[7]*qd[7]-OM17*OM17
    BS67 = qd[7]*OM27
    BETA27 = -qdd[7]+BS27
    BETA87 = BS67+OMp17
    ALPHA17 = ALPHA26*S7
    ALPHA27 = ALPHA26*C7
    ALPHA28 = ALPHA31*S8
    ALPHA38 = ALPHA31*C8
    OM19 = qd[8]*C9
    OM29 = -qd[8]*S9
    OMp19 = -qd[8]*qd[9]*S9+qdd[8]*C9
    BS29 = OM19*OM29
    BS59 = -qd[9]*qd[9]-OM19*OM19
    BS69 = qd[9]*OM29
    BETA29 = -qdd[9]+BS29
    BETA89 = BS69+OMp19
    ALPHA19 = ALPHA28*S9
    ALPHA29 = ALPHA28*C9
    ALPHA210 = ALPHA31*S10
    ALPHA310 = ALPHA31*C10
    OM111 = qd[10]*C11
    OM211 = -qd[10]*S11
    OMp111 = -qd[10]*qd[11]*S11+qdd[10]*C11
    OMp211 = -qd[10]*qd[11]*C11-qdd[10]*S11
    BS211 = OM111*OM211
    BS511 = -qd[11]*qd[11]-OM111*OM111
    BS611 = qd[11]*OM211
    BETA211 = -qdd[11]+BS211
    BETA811 = BS611+OMp111
    ALPHA111 = ALPHA210*S11
    ALPHA211 = ALPHA210*C11
    OM112 = qd[12]+OM111
    OM212 = qd[11]*S12+OM211*C12
    OM312 = qd[11]*C12-OM211*S12
    OMp112 = qdd[12]+OMp111
    OMp212 = C12*(OMp211+qd[11]*qd[12])+S12*(qdd[11]-qd[12]*OM211)
    OMp312 = C12*(qdd[11]-qd[12]*OM211)-S12*(OMp211+qd[11]*qd[12])
    ALPHA112 = ALPHA111+BETA211*s.dpt[2,12]
    ALPHA212 = C12*(ALPHA211+BS511*s.dpt[2,12])+S12*(ALPHA310+BETA811*s.dpt[2,12])
    ALPHA312 = C12*(ALPHA310+BETA811*s.dpt[2,12])-S12*(ALPHA211+BS511*s.dpt[2,12])
    OM113 = OM112*C13-OM312*S13
    OM213 = qd[13]+OM212
    OM313 = OM112*S13+OM312*C13
    OMp113 = C13*(OMp112-qd[13]*OM312)-S13*(OMp312+qd[13]*OM112)
    OMp213 = qdd[13]+OMp212
    OMp313 = C13*(OMp312+qd[13]*OM112)+S13*(OMp112-qd[13]*OM312)
    ALPHA113 = ALPHA112*C13-ALPHA312*S13
    ALPHA313 = ALPHA112*S13+ALPHA312*C13
    OM114 = OM113*C14+OM213*S14
    OM214 = -OM113*S14+OM213*C14
    OM314 = qd[14]+OM313
    OMp114 = C14*(OMp113+qd[14]*OM213)+S14*(OMp213-qd[14]*OM113)
    OMp214 = C14*(OMp213-qd[14]*OM113)-S14*(OMp113+qd[14]*OM213)
    OMp314 = qdd[14]+OMp313
    BS114 = -OM214*OM214-OM314*OM314
    BS214 = OM114*OM214
    BS314 = OM114*OM314
    BS514 = -OM114*OM114-OM314*OM314
    BS614 = OM214*OM314
    BS914 = -OM114*OM114-OM214*OM214
    BETA214 = BS214-OMp314
    BETA314 = BS314+OMp214
    BETA414 = BS214+OMp314
    BETA614 = BS614-OMp114
    BETA714 = BS314-OMp214
    BETA814 = BS614+OMp114
    ALPHA114 = ALPHA113*C14+ALPHA212*S14
    ALPHA214 = -ALPHA113*S14+ALPHA212*C14
    OM115 = OM114*C15-OM314*S15
    OM215 = qd[15]+OM214
    OM315 = OM114*S15+OM314*C15
    OMp115 = C15*(OMp114-qd[15]*OM314)-S15*(OMp314+qd[15]*OM114)
    OMp215 = qdd[15]+OMp214
    OMp315 = C15*(OMp314+qd[15]*OM114)+S15*(OMp114-qd[15]*OM314)
    ALPHA115 = C15*(ALPHA114+BETA214*s.dpt[2,14]+BETA314*s.dpt[3,14]+BS114*s.dpt[1,14])-S15*(ALPHA313+BETA714*s.dpt[1,14]+BETA814*s.dpt[2,14]+BS914*s.dpt[3,14])
    ALPHA215 = ALPHA214+BETA414*s.dpt[1,14]+BETA614*s.dpt[3,14]+BS514*s.dpt[2,14]
    ALPHA315 = C15*(ALPHA313+BETA714*s.dpt[1,14]+BETA814*s.dpt[2,14]+BS914*s.dpt[3,14])+S15*(ALPHA114+BETA214*s.dpt[2,14]+BETA314*s.dpt[3,14]+BS114*s.dpt[1,14])
 
# Backward Dynamics

    Fs115 = -s.frc[1,15]+s.m[15]*ALPHA115
    Fs215 = -s.frc[2,15]+s.m[15]*ALPHA215
    Fs315 = -s.frc[3,15]+s.m[15]*ALPHA315
    Cq115 = -s.trq[1,15]+s.In[1,15]*OMp115-s.In[5,15]*OM215*OM315+s.In[9,15]*OM215*OM315
    Cq215 = -s.trq[2,15]+s.In[1,15]*OM115*OM315+s.In[5,15]*OMp215-s.In[9,15]*OM115*OM315
    Cq315 = -s.trq[3,15]-s.In[1,15]*OM115*OM215+s.In[5,15]*OM115*OM215+s.In[9,15]*OMp315
    Fs114 = -s.frc[1,14]+s.m[14]*(ALPHA114+BETA214*s.l[2,14]+BETA314*s.l[3,14]+BS114*s.l[1,14])
    Fs214 = -s.frc[2,14]+s.m[14]*(ALPHA214+BETA414*s.l[1,14]+BETA614*s.l[3,14]+BS514*s.l[2,14])
    Fs314 = -s.frc[3,14]+s.m[14]*(ALPHA313+BETA714*s.l[1,14]+BETA814*s.l[2,14]+BS914*s.l[3,14])
    Fq114 = Fs114+Fs115*C15+Fs315*S15
    Fq214 = Fs214+Fs215
    Fq314 = Fs314-Fs115*S15+Fs315*C15
    Cq114 = -s.trq[1,14]+s.In[1,14]*OMp114+s.In[2,14]*OMp214+s.In[3,14]*OMp314+Cq115*C15+Cq315*S15-Fs214*s.l[3,14]-Fs215*s.dpt[3,14]+Fs314*s.l[2,14]+OM214*(s.In[3,14]*OM114+s.In[6,14]*OM214+s.In[9,14]*OM314)-OM314*(s.In[2,14]*OM114+s.In[5,14]*OM214+s.In[6,14]*OM314)+s.dpt[2,14]*(-Fs115*S15+Fs315*C15)
    Cq214 = -s.trq[2,14]+Cq215+s.In[2,14]*OMp114+s.In[5,14]*OMp214+s.In[6,14]*OMp314+Fs114*s.l[3,14]-Fs314*s.l[1,14]-OM114*(s.In[3,14]*OM114+s.In[6,14]*OM214+s.In[9,14]*OM314)+OM314*(s.In[1,14]*OM114+s.In[2,14]*OM214+s.In[3,14]*OM314)-s.dpt[1,14]*(-Fs115*S15+Fs315*C15)+s.dpt[3,14]*(Fs115*C15+Fs315*S15)
    Cq314 = -s.trq[3,14]+s.In[3,14]*OMp114+s.In[6,14]*OMp214+s.In[9,14]*OMp314-Cq115*S15+Cq315*C15-Fs114*s.l[2,14]+Fs214*s.l[1,14]+Fs215*s.dpt[1,14]+OM114*(s.In[2,14]*OM114+s.In[5,14]*OM214+s.In[6,14]*OM314)-OM214*(s.In[1,14]*OM114+s.In[2,14]*OM214+s.In[3,14]*OM314)-s.dpt[2,14]*(Fs115*C15+Fs315*S15)
    Fq113 = Fq114*C14-Fq214*S14
    Fq213 = Fq114*S14+Fq214*C14
    Cq113 = Cq114*C14-Cq214*S14
    Cq213 = Cq114*S14+Cq214*C14
    Fq112 = Fq113*C13+Fq314*S13
    Fq312 = -Fq113*S13+Fq314*C13
    Cq112 = Cq113*C13+Cq314*S13
    Cq312 = -Cq113*S13+Cq314*C13
    Fs111 = -s.frc[1,11]+s.m[11]*(ALPHA111+BETA211*s.l[2,11])
    Fs211 = -s.frc[2,11]+s.m[11]*(ALPHA211+BS511*s.l[2,11])
    Fs311 = -s.frc[3,11]+s.m[11]*(ALPHA310+BETA811*s.l[2,11])
    Fq111 = Fq112+Fs111
    Fq211 = Fs211+Fq213*C12-Fq312*S12
    Fq311 = Fs311+Fq213*S12+Fq312*C12
    Cq111 = -s.trq[1,11]+Cq112+Fs311*s.l[2,11]+s.dpt[2,12]*(Fq213*S12+Fq312*C12)
    Cq211 = -s.trq[2,11]+Cq213*C12-Cq312*S12
    Cq311 = -s.trq[3,11]+Cq213*S12+Cq312*C12-Fq112*s.dpt[2,12]-Fs111*s.l[2,11]
    Fq210 = Fq111*S11+Fq211*C11
    Cq110 = Cq111*C11-Cq211*S11
    Fs19 = -s.frc[1,9]+s.m[9]*(ALPHA19+BETA29*s.l[2,9])
    Fs29 = -s.frc[2,9]+s.m[9]*(ALPHA29+BS59*s.l[2,9])
    Fs39 = -s.frc[3,9]+s.m[9]*(ALPHA38+BETA89*s.l[2,9])
    Cq19 = -s.trq[1,9]+Fs39*s.l[2,9]
    Cq39 = -s.trq[3,9]-Fs19*s.l[2,9]
    Fq28 = Fs19*S9+Fs29*C9
    Cq18 = s.trq[2,9]*S9+Cq19*C9
    Fs17 = -s.frc[1,7]+s.m[7]*(ALPHA17+BETA27*s.l[2,7])
    Fs27 = -s.frc[2,7]+s.m[7]*(ALPHA27+BS57*s.l[2,7])
    Fs37 = -s.frc[3,7]+s.m[7]*(ALPHA36+BETA87*s.l[2,7])
    Cq17 = -s.trq[1,7]+Fs37*s.l[2,7]
    Cq37 = -s.trq[3,7]-Fs17*s.l[2,7]
    Fq26 = Fs17*S7+Fs27*C7
    Cq16 = s.trq[2,7]*S7+Cq17*C7
    Fs15 = -s.frc[1,5]+s.m[5]*(ALPHA15+BETA25*s.l[2,5])
    Fs25 = -s.frc[2,5]+s.m[5]*(ALPHA25+BS55*s.l[2,5])
    Fs35 = -s.frc[3,5]+s.m[5]*(ALPHA34+BETA85*s.l[2,5])
    Cq15 = -s.trq[1,5]+Fs35*s.l[2,5]
    Cq35 = -s.trq[3,5]-Fs15*s.l[2,5]
    Fq24 = Fs15*S5+Fs25*C5
    Cq14 = s.trq[2,5]*S5+Cq15*C5
    Fs13 = -s.frc[1,3]+s.m[3]*(ALPHA13+BETA23*s.l[2,3])
    Fs23 = -s.frc[2,3]+s.m[3]*(ALPHA23+BS53*s.l[2,3])
    Fs33 = -s.frc[3,3]+s.m[3]*(ALPHA32+BETA83*s.l[2,3])
    Cq13 = -s.trq[1,3]+Fs33*s.l[2,3]
    Cq33 = -s.trq[3,3]-Fs13*s.l[2,3]
    Fq22 = Fs13*S3+Fs23*C3
    Cq12 = s.trq[2,3]*S3+Cq13*C3
    Fs31 = -s.frc[3,1]+s.m[1]*ALPHA31
    Fq31 = Fs31+Fq210*S10+Fq22*S2+Fq24*S4+Fq26*S6+Fq28*S8+Fq311*C10+Fs33*C2+Fs35*C4+Fs37*C6+Fs39*C8
 
# Symbolic model output

    Qq[1] = Fq31
    Qq[2] = Cq12
    Qq[3] = Cq33
    Qq[4] = Cq14
    Qq[5] = Cq35
    Qq[6] = Cq16
    Qq[7] = Cq37
    Qq[8] = Cq18
    Qq[9] = Cq39
    Qq[10] = Cq110
    Qq[11] = Cq311
    Qq[12] = Cq112
    Qq[13] = Cq213
    Qq[14] = Cq314
    Qq[15] = Cq215
    Qq[16] = -s.frc[3,16]

# Number of continuation lines = 0


